//
//  WDInstallProcessController.h
//  Installer
//
//  Created by Clark Jackson on 12/9/10.
//  Copyright 2013 Western Digital Technologies, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "WDAuthorizedTask.h"

APPKIT_EXTERN NSString* const WDHandleSyncServiceUninstallKey;
APPKIT_EXTERN NSString* const WDHandleSmartwareServiceUninstallKey;
APPKIT_EXTERN NSString* const WDHandleSyncServiceInstallKey;
APPKIT_EXTERN NSString* const WDHandleSyncUninstallKey;
APPKIT_EXTERN NSString* const WDHandleSyncInstallKey;
APPKIT_EXTERN NSString* const WDHandleSyncUninstallAliasKey;
APPKIT_EXTERN NSString* const WDHandleSyncUninstallerInstallKey;
APPKIT_EXTERN NSString* const WDHandleDriveManagerUninstallerInstallKey;
APPKIT_EXTERN NSString* const WDSyncServiceBundleIdentifier;
APPKIT_EXTERN NSString* const WDSyncServiceAppName;
APPKIT_EXTERN NSString* const WDSmartwareServiceAppName;
APPKIT_EXTERN NSString* const WDWDDMServiceAppName;
APPKIT_EXTERN NSString* const SmartwareDriveServiceAppName;
APPKIT_EXTERN NSString* const WDMemeoServiceAppName;
APPKIT_EXTERN NSString* const WDDriveManagerServiceAppName;
APPKIT_EXTERN NSString* const WDRAIDDriveServiceAppName;
APPKIT_EXTERN NSString* const WDDriveManagerStatusMenuAppName;
APPKIT_EXTERN NSString* const WDDriveManagerStatusMenuExecName;
APPKIT_EXTERN NSString* const WDDriveManagerStatusMenuAppNameKey;
APPKIT_EXTERN NSString* const WDRAIDManagerAppName;
APPKIT_EXTERN NSString* const WDSyncNameKey;
APPKIT_EXTERN NSString* const WDSyncExecutableKey;
APPKIT_EXTERN NSString* const WDSyncKillKey;
APPKIT_EXTERN NSString* const WDLaunchWDSyncKey;
APPKIT_EXTERN NSString* const WDHandleAddingWDSyncToAutoLaunchListKey;
APPKIT_EXTERN NSString* const WDGlobalAppSupportPathKey;
APPKIT_EXTERN NSString* const WDUserAppSupportPathKey;
APPKIT_EXTERN NSString* const WDHandle64BitKEXTInstallKey;
APPKIT_EXTERN NSString* const WDRemovePathsKey;
APPKIT_EXTERN NSString* const WDChangeOwnershipOfInstallerKey;
APPKIT_EXTERN NSString* const WDHandle64BitKEXTInstallKey;
APPKIT_EXTERN NSString* const WDHandleKEXTInstallKey;
APPKIT_EXTERN NSString* const WDHandleKEXTUninstallKey;
APPKIT_EXTERN NSString* const WDHandle64BitKEXTUninstallKey;
APPKIT_EXTERN NSString* const WDHandleRemovingComponentsKey;
APPKIT_EXTERN NSString* const WDHandleInstallingComponentsKey;
APPKIT_EXTERN NSString* const WDChangeNameOfInstallersKey;
APPKIT_EXTERN NSString* const WDPathToInstalledInstallerKey;
APPKIT_EXTERN NSString* const WDPathToInstalledDriveManagerInstallerKey;
APPKIT_EXTERN NSString* const WDPathToInstalledAppKey;
APPKIT_EXTERN NSString* const WDInstallerNameKey;
// APPKIT_EXTERN NSString* const WDPathToInstalledAppKey;
APPKIT_EXTERN NSString* const WDResourcesInstallDestinationDirPathKey;
APPKIT_EXTERN NSString* const WDResourcesTmpInstallDirPathKey;
APPKIT_EXTERN NSString* const WDBillOfMaterialsInstallFromPathsKey;
APPKIT_EXTERN NSString* const WDBillOfMaterialsInstallToPathsKey;
APPKIT_EXTERN NSString* const WDLaunchDaemonsPathKey;
APPKIT_EXTERN NSString* const WDLaunchAgentsPathKey;
APPKIT_EXTERN NSString* const WDApplicationDirectoryInstallPath;
APPKIT_EXTERN NSString* const WDSmartwareServiceBundleIdentifierKey;
APPKIT_EXTERN NSString* const WDWDDMServiceBundleIdentifierKey;
APPKIT_EXTERN NSString* const WDMemeoServiceBundleIdentifierKey;
APPKIT_EXTERN NSString* const WDServicesBundleIdentifierKey;
APPKIT_EXTERN NSString* const WDDriveManagerServiceBundleIdentifierKey;
APPKIT_EXTERN NSString* const WDDriveManagerInstallerBundleIdentifierKey;
APPKIT_EXTERN NSString* const WDSmartwareDriveServiceBundleIdentifierKey;
APPKIT_EXTERN NSString* const WDRAIDDriveServiceBundleIdentifierKey;


/////////////////////
APPKIT_EXTERN NSString* const CHMODArrayKey;
APPKIT_EXTERN NSString* const CHOWNArrayKey;
APPKIT_EXTERN NSString* const UnloadArrayKey;
APPKIT_EXTERN NSString* const LoadArrayKey;
APPKIT_EXTERN NSString* const LoadArrayUnprivilegedKey;
APPKIT_EXTERN NSString* const UnloadArrayUnprivilegedKey;
APPKIT_EXTERN NSString* const CopyFromArrayKey;
APPKIT_EXTERN NSString* const CopyToArrayKey;
APPKIT_EXTERN NSString* const DeleteArraysKey;
APPKIT_EXTERN NSString* const KillProcessArrayKey;
APPKIT_EXTERN NSString* const AutoStartArrayKey;
APPKIT_EXTERN NSString* const LaunchListArrayKey;
APPKIT_EXTERN NSString* const CleanupArrayKey;
APPKIT_EXTERN NSString* const ReducePrivilegeArrayKey;
APPKIT_EXTERN NSString* const WDPathToInstalledUninstallerKey;
APPKIT_EXTERN NSString* const WDPathToInstalledInstallerKey;
APPKIT_EXTERN NSString* const InstallDriveManagerUninstallerKey;
APPKIT_EXTERN NSString* const InstallSmartWareUninstallerKey;





typedef enum isAliasStates
{
    kUnknownIfAlias,
    kIsAnAlias,
    kIsNotAnAlias
} AliasStates;

@protocol ApolloProtocol<NSObject>

- (void) doStateChange:(int)state;
- (void) presentThreadedInstallProgress;
- (void) setInstallProgress:(double) progress;
- (BOOL) bypassAuthorizationDialogFlag;
- (void) finishInstallByFramework;
- (void) finishUninstallByFramework;
- (void) cancelInstallByFramework;
- (void) cancelUninstallByFramework;
- (void) finishUninstallSmartWareAndDriveManagerByFramework;
- (void) finishInstallSmartWareByFramework;
- (void) finishUninstallSmartWareByFramework;
- (void) finishUninstallDriveManagerByFramework;
- (void) finishInstallDriveManagerByFramework;
@end



@interface WDInstallProcessController : WDAuthorizedTask<ApolloProtocol>
{
    NSDictionary* processControlDict;
    BOOL shutdownServices;
    BOOL installCanceled;
    id callerController;
    BOOL forceFailure;
    NSImage* theIconImage;
    NSString* theIconPath;
    
}

@property (readwrite, copy) NSDictionary* processControlDict;
@property (readwrite, retain) id callerController;
@property (readwrite, assign) BOOL installCanceled;
@property (readwrite, assign) BOOL forceFailure;
@property (readwrite, retain) NSImage* theIconImage;
@property (readwrite, retain) NSString* theIconPath;

- (id) initWithPlanDict:(NSDictionary*)installDict;
- (void) setupInstallDict:(NSDictionary*)installDict;
//- (void) threadedSmartWareInstall:(NSNumber *)type;
//- (void) threadedSmartWareUninstall:(NSNumber *)type;
//- (void) installWDQuickView;
//- (void) uninstallWDQuickView;
//- (void) installWDSync;
- (void) installDriveManager;
- (void) installWDSyncLaunchd;
- (void) uninstallWDSyncLaunchd;
//- (void) uninstallWDSync;
//- (void) unloadDaemon:(WDDaemonType)which;
//- (void) loadDaemon:(WDDaemonType)which;
//- (void) unloadAgent:(WDDaemonType)which;
//- (void) loadAgent:(WDDaemonType)which;
- (BOOL) shouldUpdateStatusMenu;
+ (BOOL) compareInstalledVersion:(NSString*) installedVersionString withUpdateVersion:(NSString*)updateVersionString;
- (void) killUnprivilegedApp:(NSString*)appName;
+ (int) getPIDForProcess:(NSString*) appName;
+ (NSInteger) isAlias:(NSString*)path;

#pragma mark autolaunching
- (void) removeAutoLaunchOfAppPath:(NSString*)appPath; // deprecated, appPath should look like @"/Applications/WD Sync.app"
- (void) removeAutoLaunchOfAppPath:(NSString*)appPath locally:(BOOL) doItForSession; // appPath should look like @"/Applications/WD Sync.app"
- (void) removeAutoLaunchOfAppName:(NSString *)appName;  // deprecated, should look like @"WD Sync.app"
- (void) removeAutoLaunchOfAppName:(NSString *)appName locally:(BOOL) doItForSession; // deprecated, should look like @"WD Sync.app"
- (void) setupAutoLaunchOfAppPath:(NSString*)appPath; // should look like @"/Applications/WD Sync.app"
- (void) setupAutoLaunchOfAppPath:(NSString*)appPath locally:(BOOL) doItForSession; // appPath should look like @"/Applications/WD Sync.app"
- (void) launchApp:(NSString*)appPath launchFlags:(LSLaunchFlags)launchFlags;
- (void)enableLoginItemWithLoginItemsReference:(LSSharedFileListRef )theLoginItemsRefs ForPath:(NSString *)appPath; // deprecated
- (void)enableLoginItemWithLoginItemsReference:(LSSharedFileListRef )theLoginItemsRefs ForPath:(NSString *)appPath locally:(BOOL) doItForSession;
- (void)disableLoginItemWithLoginItemsReference:(LSSharedFileListRef )theLoginItemsRefs ForPath:(NSString *)appPath; // deprecated
- (void)disableLoginItemWithLoginItemsReference:(LSSharedFileListRef )theLoginItemsRefs ForPath:(NSString *)appPath locally:(BOOL) doItForSession;
- (BOOL)loginItemExistsWithLoginItemReference:(LSSharedFileListRef)theLoginItemsRefs ForPath:(NSString *)appPath;
- (BOOL)loginItemExistsWithLoginItemReference:(LSSharedFileListRef)theLoginItemsRefs WithAppName:(NSString *)appName;
- (void)disableAnyLoginItemWithLoginItemsReference:(LSSharedFileListRef )theLoginItemsRefs WithAppName:(NSString *)appName; // deprecated
- (void)disableAnyLoginItemWithLoginItemsReference:(LSSharedFileListRef )theLoginItemsRefs WithAppName:(NSString *)appName locally:(BOOL) doItForSession;

#pragma mark favorites list in sidebar
- (void) setupSidebarFavoriteOfPath:(NSString*)favoritePath;

#pragma mark smartware install methods

-(void) uninstallSmartWareAndDriveManager;
-(void) uninstallDriveManager;
- (IBAction)installSmartWare;
-(void) uninstallSmartWare;

@end



